

<?php $__env->startSection('title', 'Plugin Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-header">
    <h1><i class="fas fa-puzzle-piece"></i> Plugin Management</h1>
    <p>Manage, install, and configure plugins for your application</p>

        <a href="https://siedestudios.github.io/edge-plugins-docs/" target="_blank" class="btn btn-outline-secondary">
        Want to create your own plugin? Learn how
        <i class="fas fa-external-link-alt ml-1"></i>
    </a>
</div>

<!-- Stats Cards -->
<div class="dashboard-stats">
    <div class="stat-card">
        <div class="stat-card-inner">
            <h3>Total Plugins</h3>
            <div class="stat-value"><?php echo e($stats['total']); ?></div>
            <div class="stat-icon">
                <i class="fas fa-puzzle-piece"></i>
            </div>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-card-inner">
            <h3>Active Plugins</h3>
            <div class="stat-value text-success"><?php echo e($stats['active']); ?></div>
            <div class="stat-icon">
                <i class="fas fa-check-circle"></i>
            </div>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-card-inner">
            <h3>Inactive Plugins</h3>
            <div class="stat-value text-warning"><?php echo e($stats['inactive']); ?></div>
            <div class="stat-icon">
                <i class="fas fa-pause-circle"></i>
            </div>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-card-inner">
            <h3>Updates Available</h3>
            <div class="stat-value text-info"><?php echo e($stats['updates']); ?></div>
            <div class="stat-icon">
                <i class="fas fa-download"></i>
            </div>
        </div>
    </div>
</div>

<!-- Action Buttons -->
<div class="plugin-actions-bar mb-4">
    <div class="d-flex justify-content-between align-items-center">
        <div class="plugin-bulk-actions" style="display: none;">
            <span class="selected-count">0 plugins selected</span>
            <div class="btn-group ml-3">
                <button class="btn btn-sm btn-success bulk-activate">
                    <i class="fas fa-play"></i> Activate
                </button>
                <button class="btn btn-sm btn-warning bulk-deactivate">
                    <i class="fas fa-pause"></i> Deactivate
                </button>
                <button class="btn btn-sm btn-danger bulk-uninstall">
                    <i class="fas fa-trash"></i> Uninstall
                </button>
            </div>
        </div>
        
        <div class="plugin-main-actions">
            <a href="<?php echo e(route('admin.plugins.install')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Install New Plugin
            </a>
        </div>
    </div>
</div>

<!-- Plugins Grid -->
<div class="plugins-grid">
    <?php $__empty_1 = true; $__currentLoopData = $plugins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plugin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="plugin-card" data-plugin="<?php echo e($plugin['name']); ?>">
        <div class="plugin-card-header">
            <div class="plugin-checkbox">
                <input type="checkbox" class="plugin-select" value="<?php echo e($plugin['name']); ?>">
            </div>
            <div class="plugin-status">
                <?php if($plugin['status'] === 'active'): ?>
                    <span class="status-badge status-active">
                        <i class="fas fa-check-circle"></i> Active
                    </span>
                <?php else: ?>
                    <span class="status-badge status-inactive">
                        <i class="fas fa-pause-circle"></i> Inactive
                    </span>
                <?php endif; ?>
                
                <?php if($plugin['has_update'] ?? false): ?>
                    <span class="status-badge status-update">
                        <i class="fas fa-arrow-up"></i> Update Available
                    </span>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="plugin-card-body">
            <div class="plugin-icon">
                <?php if(isset($plugin['icon']) && $plugin['icon']): ?>
                    <img src="<?php echo e($plugin['icon']); ?>" alt="<?php echo e($plugin['display_name'] ?? $plugin['name']); ?>">
                <?php else: ?>
                    <i class="fas fa-puzzle-piece"></i>
                <?php endif; ?>
            </div>
            
            <div class="plugin-info">
                <h3 class="plugin-name"><?php echo e($plugin['display_name'] ?? $plugin['name']); ?></h3>
                <p class="plugin-description"><?php echo e($plugin['description'] ?? 'No description available'); ?></p>
                
                <div class="plugin-meta">
                    <span class="plugin-version">
                        <i class="fas fa-tag"></i> v<?php echo e($plugin['version'] ?? '1.0.0'); ?>

                    </span>
                    <span class="plugin-author">
                        <i class="fas fa-user"></i> <?php echo e($plugin['author'] ?? 'Unknown'); ?>

                    </span>
                </div>
            </div>
        </div>
        
        <div class="plugin-card-footer">
            <div class="plugin-actions">
                <?php if($plugin['status'] === 'active'): ?>
                    <form action="<?php echo e(route('admin.plugins.deactivate', $plugin['name'])); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-sm btn-warning">
                            <i class="fas fa-pause"></i> Deactivate
                        </button>
                    </form>
                <?php else: ?>
                    <form action="<?php echo e(route('admin.plugins.activate', $plugin['name'])); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-sm btn-success">
                            <i class="fas fa-play"></i> Activate
                        </button>
                    </form>
                <?php endif; ?>
                
                <a href="<?php echo e(route('admin.plugins.show', $plugin['name'])); ?>" class="btn btn-sm btn-info">
                    <i class="fas fa-cog"></i> Configure
                </a>
                
                <button class="btn btn-sm btn-danger uninstall-plugin" data-plugin="<?php echo e($plugin['name']); ?>">
                    <i class="fas fa-trash"></i> Uninstall
                 </button>
                
                <?php if($plugin['has_update'] ?? false): ?>
                    <button class="btn btn-sm btn-primary update-plugin" data-plugin="<?php echo e($plugin['name']); ?>">
                        <i class="fas fa-download"></i> Update
                    </button>
                <?php endif; ?>
                
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div class="empty-state">
        <i class="fas fa-puzzle-piece"></i>
        <h4>No Plugins Installed</h4>
        <p>Get started by installing your first plugin</p>
        <a href="<?php echo e(route('admin.plugins.install')); ?>" class="btn btn-primary">Install Plugin</a>
    </div>
    <?php endif; ?>
</div>

<!-- Uninstall Confirmation Modal -->
<div class="modal-backdrop" id="uninstallModal">
    <div class="modal">
        <div class="modal-header">
            <h3>Confirm Plugin Uninstall</h3>
            <button class="close-btn" type="button">&times;</button>
        </div>
        <div class="modal-body">
            <p>Are you sure you want to uninstall the plugin "<span id="uninstallPluginName"></span>"?</p>
            <p class="text-warning"><i class="fas fa-exclamation-triangle"></i> This action cannot be undone and will remove all plugin data.</p>
        </div>
        <div class="modal-footer">
            <button class="btn btn-secondary close-modal">Cancel</button>
            <button class="btn btn-danger confirm-uninstall">Uninstall</button>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const pluginSelects = document.querySelectorAll('.plugin-select');
    const bulkActions = document.querySelector('.plugin-bulk-actions');
    const selectedCount = document.querySelector('.selected-count');
    const mainActions = document.querySelector('.plugin-main-actions');
    
    // Handle plugin selection
    function updateBulkActions() {
        const selected = document.querySelectorAll('.plugin-select:checked');
        
        if (selected.length > 0) {
            bulkActions.style.display = 'flex';
            mainActions.style.display = 'none';
            selectedCount.textContent = `${selected.length} plugin${selected.length > 1 ? 's' : ''} selected`;
        } else {
            bulkActions.style.display = 'none';
            mainActions.style.display = 'flex';
        }
    }
    
    pluginSelects.forEach(checkbox => {
        checkbox.addEventListener('change', updateBulkActions);
    });
    
    // Bulk actions
    document.querySelector('.bulk-activate')?.addEventListener('click', function() {
        performBulkAction('activate');
    });
    
    document.querySelector('.bulk-deactivate')?.addEventListener('click', function() {
        performBulkAction('deactivate');
    });
    
    document.querySelector('.bulk-uninstall')?.addEventListener('click', function() {
        if (confirm('Are you sure you want to uninstall the selected plugins? This action cannot be undone.')) {
            performBulkAction('uninstall');
        }
    });
    
    function performBulkAction(action) {
        const selected = Array.from(document.querySelectorAll('.plugin-select:checked')).map(cb => cb.value);
        
        if (selected.length === 0) return;
        
        fetch('<?php echo e(route("admin.plugins.bulk")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({
                action: action,
                plugins: selected
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showAlert('success', data.message);
                setTimeout(() => location.reload(), 1500);
            } else {
                showAlert('error', data.message);
            }
        })
        .catch(error => {
            showAlert('error', 'An error occurred while performing the bulk action.');
        });
    }
    
    // Plugin uninstall
    let currentUninstallPlugin = null;
    const uninstallModal = document.getElementById('uninstallModal');
    const uninstallPluginName = document.getElementById('uninstallPluginName');
    
    document.querySelectorAll('.uninstall-plugin').forEach(btn => {
        btn.addEventListener('click', function() {
            currentUninstallPlugin = this.dataset.plugin;
            uninstallPluginName.textContent = currentUninstallPlugin;
            uninstallModal.classList.add('active');
        });
    });
    
    document.querySelectorAll('.close-btn, .close-modal').forEach(btn => {
        btn.addEventListener('click', function() {
            uninstallModal.classList.remove('active');
            currentUninstallPlugin = null;
        });
    });
    
    document.querySelector('.confirm-uninstall')?.addEventListener('click', function() {
        if (!currentUninstallPlugin) return;
        
        fetch(`<?php echo e(route('admin.plugins.uninstall', '')); ?>/${currentUninstallPlugin}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showAlert('success', data.message);
                setTimeout(() => location.reload(), 1500);
            } else {
                showAlert('error', data.message);
            }
        })
        .catch(error => {
            showAlert('error', 'An error occurred while uninstalling the plugin.');
        })
        .finally(() => {
            uninstallModal.classList.remove('active');
            currentUninstallPlugin = null;
        });
    });
    
    // Close modal when clicking backdrop
    uninstallModal.addEventListener('click', function(e) {
        if (e.target === this) {
            this.classList.remove('active');
            currentUninstallPlugin = null;
        }
    });
    
    // Alert system
    function showAlert(type, message) {
        const alertDiv = document.createElement('div');
        alertDiv.className = `alert alert-${type === 'success' ? 'success' : 'danger'} alert-dismissible`;
        alertDiv.innerHTML = `
            <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'}"></i>
            ${message}
            <button type="button" class="alert-close" onclick="this.parentElement.remove()">
                <i class="fas fa-times"></i>
            </button>
        `;
        
        document.querySelector('.dashboard-header').insertAdjacentElement('afterend', alertDiv);
        
        setTimeout(() => {
            if (alertDiv.parentElement) {
                alertDiv.remove();
            }
        }, 5000);
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/admin/plugins/index.blade.php ENDPATH**/ ?>